<?php
/**
 * Section Styling
 *
 * @package Hair_Salon
 */

thim_customizer()->add_section(
	array(
		'id'       => 'general_styling',
		'panel'    => 'general',
		'title'    => esc_html__( 'Styling', 'eduma' ),
		'priority' => 30,
	)
);

// Select Theme Primary Colors
thim_customizer()->add_field(
	array(
		'id'        => 'thim_body_primary_color',
		'type'      => 'color',
		'label'     => esc_html__( 'Primary Color', 'eduma' ),
		'tooltip'   => esc_html__( 'Allows you to choose a primary color for your site.', 'eduma' ),
		'section'   => 'general_styling',
		'priority'  => 10,
		'default'   => '#ffb606',
		'transport' => 'postMessage',
		'js_vars'   => array(
			array(
				'function' => 'style',
				'element'  => '
                    .product-grid .product__title .title:hover,
					.user-info .edit-profile a,
					.user-info .edit-profile a:hover,
					.thim-other-member:hover .owl-buttons .owl-prev:hover .fa,
					.thim-other-member:hover .owl-buttons .owl-next:hover .fa,
					.widget-area.sidebar-events .widget_book-event ul li.event-cost .value,
					.pmpro-has-access #pmpro_invoices_table tbody tr td a:hover,
					.pmpro-has-access #pmpro_account-invoices tbody tr td a:hover,
					.thim-testimonial-carousel .owl-buttons .owl-prev,
					.thim-testimonial-carousel .owl-buttons .owl-next,
					.pmpro-has-access .navigation a:hover,
					.pmpro-has-access .pmpro_actionlinks a:hover,
					.pmpro-has-access a,
					.thim-category-tabs .nav-tabs li a:hover,
					.thim-category-tabs .nav-tabs li.active a,
					form.lp-checkout .logged-in a,
					.learn-press-cart-table tbody .cart_item .course-name a:hover,
					.portfolio-content .tags ul li a,
					#thim-popup-login .thim-login-container .link-bottom a,
					.thim-owl-carousel-post.thim-list-posts .read-more,
					.thim-owl-carousel-post.thim-list-posts .title a:hover,
					.landing-image .title a:hover,
					.woocommerce .woocommerce-info a,
					.woocommerce .woocommerce-message a,
					.list-book-event thead th a:hover,
					.list-book-event thead td a:hover,
					.list-book-event tbody th a:hover,
					.list-book-event tbody td a:hover,
					.btn-border:hover,
					input[type=checkbox]:checked:before,
					#buddypress div#item-header .item-meta a,
					#buddypress div#item-header .item-meta a:hover,
					#buddypress #members-list li .item .item-title > a:hover,
					#buddypress #members-list li .item .item-title .activity-read-more a,
					#buddypress #members-list li .item .item-title .activity-read-more a:hover,
					#buddypress .acomment-meta a:first-child:hover,
					#buddypress div.activity-comments > ul > li .acomment-options a,
					#buddypress div.activity-comments > ul > li .acomment-options a:hover,
					#buddypress .activity-list .activity-content .activity-header,
					.comment-header a:not(.activity-time-since):hover,
					.breadcrumbs-wrapper #breadcrumbs a:hover,
					#buddypress div.item-list-tabs#subnav ul li.selected a,
					#buddypress div.item-list-tabs#subnav ul li.current a,
					.thim-latest-new-university .thim-owl-carousel-post .title a:hover,
					.widget_shopping_cart .widget_shopping_cart_content .cart_list.product_list_widget li a:hover,
					.thim-course-grid .course-item .thim-course-content .course-title a:hover,
					.thim-course-grid .course-item .thim-course-content .course-meta > div a:hover,
					#tab-course-review .add-review .review-stars-rated,
					#tab-course-review .add-review .review-stars-rated .review-stars,
					#tab-course-review .course-rating .average-rating .rating-box .average-value,
					.thim-testimonial-slider .control-nav:hover,
					.thim-testimonial-slider .control-nav:hover:before,
					.thim-widget-tab .nav-tabs li a .fa,
					.thim-list-event.layout-2 .view-all,
					.thim-list-event .view-all:hover,
					.thim-list-event .item-event .time-from,
					.thim-list-event .item-event .title a:hover,
					.thim-login .link-bottom a,
					.list-tab-event .nav-tabs li.active .fa,
					.profile-tabs .nav-tabs li.active .fa,
					.tp-event-organizers .owl-buttons .owl-prev:hover .fa,
					.tp-event-organizers .owl-buttons .owl-next:hover .fa,
					.single-quiz .quiz-clock .quiz-timer #quiz-countdown-value,
					.single-quiz .quiz-clock .quiz-timer #quiz-countdown,
					.single-quiz .quiz-clock .quiz-total .quiz-text .number,
					.single-quiz .quiz-questions.list-quiz-questions ul li a:hover,
					.single-quiz .quiz-questions.list-quiz-questions ul li.current a,
					.question-hint .quiz-hint-toggle,
					.bbpress .bbp-topic-description .bbp-author-name,
					.bbpress #bbpress-forums li.bbp-body ul .bbp-forum-title:hover,
					.bbpress #bbpress-forums li.bbp-body ul .bbp-topic-permalink:hover,
					.bbpress #bbpress-forums li.bbp-body ul .bbp-author-name,
					.bbpress #bbpress-forums .bbp-breadcrumb a:hover,
					.bbpress #bbpress-forums #bbp-user-body a:hover,
					.bbpress #bbpress-forums #bbp-single-user-details #bbp-user-navigation a:hover,
					.bbpress #bbpress-forums #bbp-single-user-details #bbp-user-navigation li.current a,
					.thim-widget-icon-box .wrapper-box-icon.has_custom_image:not(.overlay) .smicon-read:hover,
					.thim-carousel-instructors .instructor-item .readmore:hover,
					.thim-carousel-instructors .instructor-item .readmore,
					.thim-color:hover,
					.thim-latest-new-university .thim-owl-carousel-post .owl-controls .owl-prev:hover .fa,
					.thim-latest-new-university .thim-owl-carousel-post .owl-controls .owl-next:hover .fa,
					.wrapper-lists-our-team .our-team-item .title a:hover,
					.thim-course-megamenu .course-title a:hover,
					footer#colophon .copyright-area .text-copyright a,
					body .vc_tta.vc_tta-spacing-1 .vc_tta-tab .vc_active a .fa,
					.thim-owl-carousel-post.layout-2 .owl-controls .owl-buttons .owl-prev i,
					.thim-owl-carousel-post.layout-2 .owl-controls .owl-buttons.owl-next i,
					.thim-owl-carousel-post.layout-2 .owl-controls .owl-buttons .owl-prev:hover,
					.thim-owl-carousel-post.layout-2 .owl-controls .owl-buttons.owl-next:hover,
					.thim-owl-carousel-post.layout-3 .owl-controls .owl-buttons .owl-prev:hover .fa,
					.thim-owl-carousel-post.layout-3 .owl-controls .owl-buttons .owl-next:hover .fa,
					.thim-owl-carousel-post.layout-3 .owl-controls .owl-buttons .owl-prev:hover,
					.thim-owl-carousel-post.layout-3 .owl-controls .owl-buttons .owl-next:hover,
					.thim-simple-wrapper .event-wrapper:hover .title a,
					.thim-right-bg-secondary-color .thim-list-post-inner .link_read_more a:hover,
					.thim-widget-carousel-categories .link-view-all:hover,
					.thim-sidebar-content .twitter-inner a:hover,
					.thim-grid-posts .article-wrapper:hover .title a,
					.thim-experience .title,
					.thim-list-post-inner .link_read_more a:hover,
					.thim-footer-info-3 .heading,
					#learn-press-course-curriculum ul.curriculum-sections .section-header .meta,
					#your-profile .link-change-password,
					#popup-sidebar .learn-press-breadcrumb a,
					#popup-sidebar .learn-press-breadcrumb .fa,
					#learn-press-course-curriculum ul.curriculum-sections .section-header:hover .collapse,
					.lp-pmpro-membership-list .item-td a:hover,
					.list-event-slider .view-all:hover,
					li.product-category h3:hover,
					.course-item .course-thumbnail .course-wishlist-box .course-wishlisted,
					.course-item .course-thumbnail .course-wishlist-box .course-wishlist:hover,
					.learn-press .tab-content .course-wishlist-box span.fa.course-wishlisted,
					.thim-course-list .course-item .thim-course-content .course-title a:hover,
					.rating-box .review-stars-rated .review-stars >li span,
					.course-review .review-stars-rated .review-stars >li span,
					.switch-layout-container .switch-layout a.switch-active,
					.switch-layout-container .switch-layout a:hover,
					.thim-widget-courses .view-all-courses:hover,
					.thim-course-carousel .owl-controls .owl-prev:hover .fa,
					.thim-course-carousel .owl-controls .owl-next:hover .fa,
					.thim-carousel-course-categories .owl-carousel .owl-item .title a:hover,
					.learn-press .course-tabs .nav-tabs li.active a .fa,
					.learn-press #learn_press_payment_form .learn_press_payment_close:hover,
					#learn-press-course-curriculum .section-content .course-lesson a,
					#learn-press-course-curriculum .section-content .course-quiz a,
					#learn-press-course-curriculum .section-content .course-lesson .course-format-icon .fa,
					#learn-press-course-curriculum .section-content .course-quiz .course-format-icon .fa,
					#tab-course-description .thim-course-info ul li .fa,
					#customer_login form .link-bottom a,
					#customer_login form .lost-password a,
					#customer_login form .link-bottom a:hover,
					#customer_login form .lost-password a:hover,
					.woocommerce div.product .woocommerce-tabs .entry-content #reviews #comments .commentlist li .comment-text .meta strong,
					.woocommerce .woocommerce-shipping-calculator a,
					.woocommerce .comment-form-rating a,
					.woocommerce .comment-form-rating a:hover,
					.woocommerce .star-rating span:before,
					.woocommerce .star-rating:before,
					.woocommerce .star-rating,
					.woocommerce div.woocommerce-message:before,
					.woocommerce div.woocommerce-info:before,
					.woocommerce .form-row label.checkbox a,
					.woocommerce .woocommerce-info .showcoupon,
					.product-grid .product__title .title a:hover,
					.quickview .product-info .right .product_meta a:hover,
					.page-404-content a:hover,
					.counter-box .display-percentage,
					.widget-area .thim-course-list-sidebar .thim-course-content .course-title a:hover,
					.widget-area .thim-list-posts.sidebar .article-title-wrapper a:hover,
					.widget-area aside.widget ul li a:hover,
					.widget-area aside.widget ul li.current-cat a,
					#respond .logged-in-as a:hover,
					#respond #cancel-comment-reply-link:hover,
					.comments-area .comment-list .comment-list-inner li .comment-extra-info .author a:hover,
					.related-archive ul.archived-posts > li h5 a:hover,
					.entry-navigation-post .next-post .title a:hover,
					.entry-navigation-post .prev-post .title a:hover,
					.thim-about-author .author-top a.name:hover,
					.entry-tag-share .post-tag a:hover,
					article .entry-header .entry-title a:hover,
					article .entry-header .date-meta,
					.thim-widget-accordion .panel-title a:not(.collapsed):after,
					.thim-owl-carousel-post .owl-controls.owl-prev:hover .fa,
					.thim-owl-carousel-post .owl-controls.owl-next:hover .fa,
					.thim-owl-carousel-post .title a:hover,
					.thim-social li a:hover,
					footer#colophon .footer a:hover,
					footer#colophon .footer .thim-footer-location .info a:hover,
					footer#colophon .footer .thim-footer-location .social a:hover,
					.thim-course-search-overlay .search-toggle:hover,
					.site-header.affix .thim-course-search-overlay .search-toggle:hover,
					.thim-mobile-login a:hover,
					.thim-color,
					.one-courses-page-content .row-item .courses-price,
					.one-courses-page-content .row-item .number-students:before,
					input[type=checkbox]:checked:before,
					.btn-border,
					.breadcrumbs-wrapper #breadcrumbs li a:hover,
  					.list-info li i,
					.list-address li i,
					.flexslider .flex-direction-nav .flex-prev:before,
					.flexslider .flex-direction-nav .flex-next:before,
					.comments-area .comment-list .comment-list-inner li .comment-extra-info a:hover,
					.quickview .product-info .right .cart a:hover,
					.quickview .quick-view-detail:hover,
					.woocommerce div.product .woocommerce-review-link:hover,
					.woocommerce div.product .product_meta a:hover,
					.woocommerce-page .product-name a:hover
                    ',
				'property' => 'color',
			),
			array(
				'function' => 'style',
				'element'  => '
							.footer-bottom .thim-widget-icon-box:before,
							.wrapper-lists-our-team .our-team-item .our-team-image:before,
							.thim-bg-overlay-color-half:before,
							.thim-owl-carousel-post .info,
							.thim-bg-overlay-color:before,
							.thim-testimonial-slider ul.scrollable li:before,
							.product-grid .product__title a.added_to_cart,
							.pagination li .page-numbers:hover,
							.pagination li .page-numbers.current,
							.loop-pagination li .page-numbers:hover,
							.loop-pagination li .page-numbers.current,
							.thim-widget-carousel-categories .content-wrapper,
							body .vc_tta.vc_tta-spacing-1 .vc_tta-tab .vc_active:before,
							.lp_pmpro_courses_by_level .level-wrap header .lp_pmpro_title_level:before,
							.lp_pmpro_courses_by_level .level-wrap footer a,
							.pmpro-has-access input.pmpro_btn,
							.pmpro-has-access a.pmpro_btn,
							#learn-press-form-login input[type=submit],
							.widget-area.sidebar-events .book-title,
							.widget-area.sidebar-events .widget_book-event .event_register_foot .event_register_submit,
							.thim-buy-now-desc:before,
							#thim-popup-login .thim-login-container .close-popup,
							.thim-owl-carousel-post.thim-list-posts .info,
							.thim-timetable-link,
							.woocommerce-MyAccount-navigation li.is-active:before,
							.thim-search-light-style .thim-widget-courses-searching .courses-searching button,
							.thim-button-checkout,
							.thim-text-title:before,
							body .vc_tta.vc_general .vc_active .vc_tta-panel-title > a:before,
							body .vc_tta.vc_general .vc_tta-panel-title:hover > a:before,
							.thim-widget-courses .view-all-courses.position-bottom,
							.woocommerce .add_to_cart_button.ajax_add_to_cart,
							.cssload-loader-inner-style-2,
							.widget_shopping_cart .minicart_hover .cart-items-number span.wrapper-items-number,
							.widget_shopping_cart .widget_shopping_cart_content .buttons a:hover,
							.thim-course-grid .course-item .thim-course-content .course-meta:before,
							.thim-course-grid .course-item .course-thumbnail > a.course-readmore,
							#tab-course-review .add-review form button[type=submit],
							#tab-course-review .review-load-more #course-review-load-more,
							#tab-course-review .course-rating .detailed-rating .stars > div.bar .full_bar > div,
							.thim-widget-tab .nav-tabs li.active:before,
							.wrapper-lists-our-team a.join-our-team,
							.site-main .widget_text .widget-title:before,
							.rev_slider_wrapper .tp-bullet.selected,
							.become-teacher-form button[type=submit],
							.thim-about-us-quote hr,
							.thim-login form#loginform input[type=submit],
							.thim-login form#registerform input[type=submit],
							.thim-login form#lostpasswordform input[type=submit],
							.thim-login form#resetpassform input[type=submit],
							.thim-list-content li:before,
							.tp-event-archive .entry-content .tp_event_view-detail,
							.list-tab-event .nav-tabs li.active:before,
							.profile-tabs .nav-tabs li.active:before,
							.single-quiz button.check_answer:hover,
							.single-quiz button.next-question:hover,
							.single-quiz button.prev-question:hover,
							.single-quiz button.button-finish-quiz:hover,
							.single-quiz button.button-start-quiz:hover,
							.bbpress #bbpress-forums li.bbp-header,
							.bbpress #bbpress-forums button:hover,
							.thim-what-it-about-desc .button .thim-button,
							a.widget-button,
							.menu-right .thim-link-login a,
							.thim-join-the-elite-group:before,
							.thim-join-the-elite-group .thim-widget-button .widget-button.normal,
							.thim-welcome-university .thim-register-now-form .wpcf7-form .wpcf7-submit,
							.thim-course-megamenu .course-readmore,
							#buddypress div.item-list-tabs ul li.selected:before,
							#buddypress div.item-list-tabs ul li.current:before,
							#buddypress .bp-avatar-nav ul.avatar-nav-items li.selected:before,
							#buddypress .bp-avatar-nav ul.avatar-nav-items li.current:before,
							#buddypress input[type=submit],
							#buddypress a.button:hover,
							#buddypress div#item-header div.generic-button > a:hover,
							li form.ac-form .ac-reply-content .ac-reply-cancel:hover,
							li form.ac-form .ac-reply-content input[type=submit],
							.rev-btn.thim-slider-button,
							form.lp-cart .checkout-button,
							#learn-press-checkout-user-form #learn-press-checkout-user-register .form-content a,
							#learn-press-checkout-user-form #learn-press-checkout-user-login ul.form-fields li button,
							.learn-press .view-cart-button:hover,
							#learn-press-payment .place-order-action input.button,
							#learn-press-payment .place-order-action input.button,
							#learn-press-payment .place-order-action input.button:hover,
							input[type=radio]:checked:before,
							#learn-press-finish-course,
							#learn-press-checkout-user-form #learn-press-checkout-user-login ul.form-fields li button,
							#learn-press-checkout-user-form #learn-press-checkout-user-register .form-content a,
							.overlay-black .thim-widget-courses-searching .courses-searching button,
							.event_button_disable,
							.owl-controls .owl-pagination .owl-page:hover,
							.owl-controls .owl-pagination .owl-page.active,
							aside .woof_container_size .woof_list li input[type=radio]:checked:before,
							.thim-widget-icon-box .line-heading,
							.widget-area aside.WOOF_Widget .woof_container .woof_container_inner:before,
							.thim-course-landing-button .woocommerce-message a.button,
							.course-payment .woocommerce-message a.button,
							form.pmpro_form .lp-pmpro-name,
							.loop-pagination .page-number,
							.loop-pagination a:hover .page-number,
							.blog-switch-layout.blog-grid article .entry-grid-meta:before,
							.woocommerce-product-search:after,
							.learn-press-pmpro-buy-membership a.button:hover,
							.lp-course-progress .lp-progress-bar .lp-progress-value,
							.grid-horizontal .item-post:nth-child(2n) .article-wrapper,
							.cssload-loader-style-3 .sk-cube:before,
							#learn-press-course-curriculum ul.curriculum-sections .section-content .course-lesson.current:after,
							#learn-press-course-curriculum ul.curriculum-sections .section-content .course-lesson.item-current:after,
							#learn-press-course-curriculum ul.curriculum-sections .section-content .course-lesson .lesson-preview:hover,
							#learn-press-course-curriculum ul.curriculum-sections .section-content .course-quiz.current:after,
							#learn-press-course-curriculum ul.curriculum-sections .section-content .course-quiz.item-current:after,
							#learn-press-course-curriculum ul.curriculum-sections .section-content .course-quiz .lesson-preview:hover,
							#your-profile input[type=submit],
							#course-curriculum-popup #popup-header,
							#popup_container #popup_title,
							#popup_panel #popup_ok,
							#popup_panel #popup_ok:hover,
							#popup_panel #popup_cancel:hover,
							#popup_title,
							.course-content .popup-title,
							.mfp-content .popup-title,
							.quiz-buttons .button-hint:hover,
							.quiz-buttons .button-next-question:hover,
							.quiz-buttons .button-check-answer:hover,
							.quiz-buttons .button-prev-question:hover,
							.lp-pmpro-membership-list .header-item.position-2:before,
							.cssload-loading i,
							.learn-press #learn_press_payment_form .learn_press_payment_close .learn_press_payment_checkout:hover,
							.learn-press .thim-enroll-course-button,
							.learn-press .course-tabs .nav-tabs li.active:before,
							.learn-press #finish-course,
							.learn-press .course-meta >div .value.lp-progress-bar .lp-progress-value,
							#learn-press-course-curriculum .section-content .course-lesson a.lesson-preview:hover,
							#learn-press-course-curriculum .section-content .course-quiz a.lesson-preview:hover,
							.course-content .complete-lesson-button,
							.thim-course-menu-landing .thim-course-landing-tab li.active:before,
							.thim-course-list .course-item .thim-course-content .course-readmore a,
							.woocommerce div.product .woocommerce-tabs .tabs.wc-tabs li.active:before,
							.woocommerce div.product .woocommerce-tabs .entry-content #reviews #review_form_wrapper .comment-form .form-submit .submit,
							.woocommerce-page .button:hover,
							.woocommerce div.product form.cart .button,
							.woocommerce div.product .onsale,
							.product_thumb .onsale,
							.quickview .product-info .right .cart button.button,
							.product-grid .product__title .title a.button.add_to_cart_button,
							.product-grid .product__title .title a.added_to_cart,
							.widget-area aside:before,
							article .readmore a,
							.thim-widget-accordion .panel-title a:not(.collapsed):before,
							.thim-register-now-form .wpcf7-form .wpcf7-submit:hover,
							.thim-register-now-form .title:before,
							.mc4wp-form .mc4wp-form-fields button[type=submit],
							.mc4wp-form .mc4wp-form-fields input[type=submit],
							.wpcf7-form .wpcf7-submit,
							.navigation .navbar-nav #magic-line,
							.thim-bg-color,
							input[type=radio]:checked:before,
							.btn-primary,
							.top_site_main .page-title-wrapper h1:before,
							.top_site_main .page-title-wrapper h2:before,
							.thim-widget-courses-searching .thim-course-search-overlay .courses-searching button,
							#respond.comment-respond .comment-form .form-submit input#submit,
							.comments-area .comment-list .comment-list-inner .form-submit input#submit,
							.wpcf7-form.style-02 .contact-form-content .submit-btn input,
							.wpcf7-form.style-01 .contact-form-content .submit-btn input,
							#back-to-top:hover,
							input[type=submit],
							button
							',
				'property' => 'background-color',
			),
			array(
				'function' => 'style',
				'element'  => '
							.thim-widget-portfolio  .wapper_portfolio .filters .portfolio-tabs li a.filter:hover,
							.portfolio_container .wapper_portfolio .filters .portfolio-tabs li a.filter:hover,
							.thim-widget-portfolio  .wapper_portfolio .filters .portfolio-tabs li a.active,
							.portfolio_container .wapper_portfolio .filters .portfolio-tabs li a.active,
							.thim-other-member:hover .owl-buttons .owl-prev:hover,
							.thim-other-member:hover .owl-buttons .owl-next:hover,
							#learn-press-form-login input[type=email]:focus,
							#learn-press-form-login input[type=password]:focus,
							#learn-press-form-login input[type=text]:focus,
							.btn-border:hover,
							.owl-controls .owl-pagination .owl-page:hover,
							.owl-controls .owl-pagination .owl-page.active,
							.thim-product-switch-wrap form.woocommerce-ordering select:focus,
							aside .woof_container_size .woof_list li input[type=radio],
							form#lostpasswordform p input[type=text]:focus,
							form#lostpasswordform p input[type=email]:focus,
							form#lostpasswordform p input[type=password]:focus,
							.thim-login form#registerform input[type=email]:focus,
							.thim-login form#loginform input[type=email]:focus,
							.thim-login form#registerform input[type=password]:focus,
							.thim-login form#loginform input[type=password]:focus,
							.thim-login form#registerform input[type=text]:focus,
							.thim-login form#loginform input[type=text]:focus,
							.thim-login form#resetpassform input[type=text]:focus,
							form#registerform input[type=password]:focus,
							.thim-latest-new-university .thim-owl-carousel-post .owl-controls .owl-prev:hover,
							.thim-latest-new-university .thim-owl-carousel-post .owl-controls .owl-next:hover,
							.thim-testimonial-slider .control-nav:hover,
							.rev_slider_wrapper .tp-bullet.selected,
							.thim-list-event .view-all:hover,
							.thim-list-event.layout-2 .time-from,
							.tp-event-organizers .owl-buttons .owl-prev:hover,
							.tp-event-organizers .owl-buttons .owl-next:hover,
							.thim-join-the-elite-group .thim-widget-button .widget-button.normal,
							.activity-list li.bbp_topic_create .activity-content .activity-inner,
							.activity-list li.bbp_reply_create .activity-content .activity-inner,
							body .vc_tta.vc_general .vc_active .vc_tta-panel-title .vc_tta-controls-icon:before,
							body .vc_tta.vc_general .vc_active .vc_tta-panel-title .vc_tta-controls-icon:after,
							body .vc_tta.vc_general .vc_tta-panel-title:hover .vc_tta-controls-icon:before,
							body .vc_tta.vc_general .vc_tta-panel-title:hover .vc_tta-controls-icon:after,
							#respond.comment-respond .comment-form .comment-form-author input:focus,
							#respond.comment-respond .comment-form .comment-form-email input:focus,
							#respond.comment-respond .comment-form .comment-form-url input:focus,
							#respond.comment-respond .comment-form textarea:focus,
							.woocommerce .woocommerce-tabs #reviews #review_form_wrapper .comment-form p input:focus,
							.woocommerce .woocommerce-tabs #reviews #review_form_wrapper .comment-form p textarea:focus,
							.woocommerce #customer_login input[type=text]:focus,
							.woocommerce #customer_login input[type=email]:focus,
							.woocommerce #customer_login input[type=password]:focus,
							.cssload-loader-style-2,
							.loop-pagination .page-number,
							.loop-pagination a:hover .page-number,
							.thim-course-carousel .owl-controls .owl-prev:hover,
							.thim-course-carousel .owl-controls .owl-next:hover,
							.thim-widget-courses .view-all-courses:hover,
							.filter-controls li a:hover,
							.filter-controls li a.active,
							.product-cat li a:hover,
							.product-cat li a.active,
							.thim-owl-carousel-post .owl-controls.owl-prev:hover,
							.thim-owl-carousel-post .owl-controls.owl-next:hover,
							.mc4wp-form .mc4wp-form-fields input[type=email]:focus,
							.wpcf7-form input[type=text]:focus,
							.wpcf7-form input[type=email]:focus,
							.wpcf7-form input[type=tel]:focus,
							.wpcf7-form input[type=number]:focus,
							.wpcf7-form input[type=date]:focus,
							.wpcf7-form select:focus,
							.wpcf7-form textarea:focus,
							.thim-social li a:hover,
							footer#colophon .footer .thim-footer-location .social a:hover,
							.btn-primary,
							.btn-border,
							.search-form .search-field:focus,
							#bbp-search-form > .bbp-search-box #bbp_search:focus,
							.switch-layout-container .courses-searching form input[type=text]:focus,
							.pagination li .page-numbers:hover,
							.pagination li .page-numbers.current,
							.loop-pagination li .page-numbers:hover,
							.loop-pagination li .page-numbers.current
							',
				'property' => 'border-color',
			)
		),
		'choices'   => array( 'alpha' => true ),
	)
);

// Select Theme Secondary Colors
thim_customizer()->add_field(
	array(
		'id'        => 'thim_body_secondary_color',
		'type'      => 'color',
		'label'     => esc_html__( 'Secondary Color', 'eduma' ),
		'tooltip'   => esc_html__( 'Allows you to choose a secondary color for your site.', 'eduma' ),
		'section'   => 'general_styling',
		'priority'  => 10,
		'choices'   => array( 'alpha' => true ),
		'default'   => '#4caf50',
		'transport' => 'postMessage',
		'js_vars'   => array(
			array(
				'function' => 'style',
				'element'  => '
							#colophon.thim-footer-university-4 .copyright-area .text-copyright a,
							#colophon.thim-footer-university-4 .mc4wp-form:after,
							#colophon.thim-footer-university-4 .mc4wp-form.focus-input:after,
							#colophon.thim-footer-university-4 .email a,
							.thim-footer-info-4 .info .heading
							',
				'property' => 'color',
			),
			array(
				'function' => 'style',
				'element'  => '
							.thim-right-bg-secondary-color:before,
							.thim-left-full-bg-secondary-color:before,
							.list-event-slider .item-event .event-wrapper .box-time:after,
							.thim-simple-wrapper .navigation div:hover	
							',
				'property' => 'background-color',
			),
			array(
				'function' => 'style',
				'element'  => '
							.thim-simple-wrapper .pagination .item.active,
							.list-event-slider .item-event .event-wrapper .box-time:before
								',
				'property' => 'border-color',
			)
		),
	)
);

thim_customizer()->add_field(
	array(
		'id'        => 'thim_button_hover_color',
		'type'      => 'color',
		'label'     => esc_html__( 'Button Hover Background Color', 'eduma' ),
		'tooltip'   => esc_html__( 'Allows you to choose a button hover background color for your site.', 'eduma' ),
		'section'   => 'general_styling',
		'priority'  => 10,
		'choices'   => array( 'alpha' => true ),
		'default'   => '#e6a303',
		'transport' => 'postMessage',
		'js_vars'   => array(
			array(
				'function' => 'style',
				'element'  => 'input[type=submit]:hover,
								button:hover,
								.comments-area .comment-list .comment-list-inner .form-submit input#submit:hover,
								#respond.comment-respond .comment-form .form-submit input#submit:hover,
								.wpcf7-form .wpcf7-submit:hover,
								.thim-newlleter-homepage .mc4wp-form .mc4wp-form-fields button[type="submit"]:hover,
								.thim-newlleter-homepage .mc4wp-form .mc4wp-form-fields input[type="submit"]:hover,
								article .readmore a:hover,
								.quickview .product-info .right .cart button.button:hover,
								.mfp-image-holder .course-content .mfp-close,
								.mfp-inline-holder .course-content .mfp-close,
								.woocommerce div.product form.cart .button:hover,
								.thim-course-grid .course-item .course-thumbnail > a.course-readmore:hover,
								.thim-course-list .course-item .thim-course-content .course-readmore a:hover,
								.learn-press #finish-course:hover,
								.learn-press .thim-enroll-course-button:hover,
								.course-content .complete-lesson-button:hover,
								#tab-course-review .add-review form button[type="submit"]:hover,
								#tab-course-review .review-load-more #course-review-load-more:hover,
								.become-teacher-form button[type=submit]:hover,
								.wrapper-lists-our-team a.join-our-team:hover,
								.thim-login form#loginform input[type=submit]:hover,
								.thim-login form#registerform input[type=submit]:hover,
								.thim-login form#lostpasswordform input[type=submit]:hover,
								.thim-login form#resetpassform input[type=submit]:hover,
								.tp-event-archive .entry-content .tp_event_view-detail:hover,
								.menu-right .thim-link-login a:hover,
								.thim-what-it-about-desc .button .thim-button:hover,
								.thim-join-the-elite-group .thim-widget-button .widget-button.normal:hover,
								.thim-welcome-university .thim-register-now-form .wpcf7-form .wpcf7-submit:hover,
								.thim-course-megamenu .course-readmore:hover,
								.thim-buy-now .thim-widget-button .widget-button:hover,
								form.lp-cart .checkout-button:hover,
								#learn-press-finish-course:hover,
								#learn-press-checkout-user-form #learn-press-checkout-user-login ul.form-fields li button:hover,
								#learn-press-checkout-user-form #learn-press-checkout-user-register .form-content a:hover,
								#learn-press-form-login input[type="submit"]:hover,
								.pmpro-has-access input.pmpro_btn:hover,
								.pmpro-has-access a.pmpro_btn:hover,
								.widget-area.sidebar-events .widget_book-event .event_register_foot .event_register_submit:hover,
								.lp_pmpro_courses_by_level .level-wrap footer a :hover,
								.thim-timetable-link:hover,
								.thim-search-light-style .thim-widget-courses-searching .courses-searching button:hover,
								.thim-button-checkout:hover,
								.thim-widget-courses .view-all-courses.position-bottom:hover,
								.woocommerce .add_to_cart_button.ajax_add_to_cart:hover,
								#your-profile input[type=submit]:hover,
								#course-curriculum-popup #popup-header .popup-close,
								#course-curriculum-popup #popup-header .popup-close:hover,
								#popup_panel #popup_ok:hover,
								.thim-course-landing-button .woocommerce-message a.button:hover,
								.course-payment .woocommerce-message a.button:hover,
								.comments-area .comment-list .comment-list-inner .form-submit input#submit,
								.product-grid .product__title a.button.add_to_cart_button:hover,
								.woocommerce div.product .woocommerce-tabs .entry-content #reviews #review_form_wrapper .comment-form .form-submit .submit:hover,
								.quickview .product-info .right .cart button.button:hover,
								.widget_shopping_cart .widget_shopping_cart_content .buttons a.checkout:hover,
								.woocommerce div.product form.cart .button:hover,
								.woocommerce-page div.product form.cart .button:hover,
								.woocommerce #payment #place_order:hover,
								.woocommerce-page #payment #place_order:hover,
								.woocommerce .wc-proceed-to-checkout a.button:hover,
								.woocommerce-page .wc-proceed-to-checkout a.button:hover,
								#customer_login form input[type=submit]:hover,
								.woocommerce .reset_password form input[type=submit]:hover,
								.rev-btn.thim-slider-button:hover,
								.woocommerce-MyAccount-content form input.button:hover',
				'property' => 'background-color',
			),
		),
	)
);

thim_customizer()->add_field(
	array(
		'id'        => 'thim_button_text_color',
		'type'      => 'color',
		'label'     => esc_html__( 'Button Text Color', 'eduma' ),
		'tooltip'   => esc_html__( 'Allows you to choose a button text color for your site.', 'eduma' ),
		'section'   => 'general_styling',
		'priority'  => 10,
		'choices'   => array( 'alpha' => true ),
		'default'   => '#333',
		'transport' => 'postMessage',
		'js_vars'   => array(
			array(
				'function' => 'style',
				'element'  => '.site-header li .widget_shopping_cart .widget_shopping_cart_content .buttons a.button.wc-forward.checkout,
								.pagination li .page-numbers:hover,
								.pagination li .page-numbers.current,
								.loop-pagination li .page-numbers:hover,
								.loop-pagination li .page-numbers.current,
								input[type=submit],
								button,
								input[type=submit]:hover,
								button:hover,
								.comments-area .comment-list .comment-list-inner .form-submit input#submit:hover,
								#respond.comment-respond .comment-form .form-submit input#submit,
								.wpcf7-form .wpcf7-submit,
								.thim-newlleter-homepage .mc4wp-form .mc4wp-form-fields button[type="submit"]:hover,
								.thim-newlleter-homepage .mc4wp-form .mc4wp-form-fields input[type="submit"]:hover,
								.mc4wp-form .mc4wp-form-fields button[type="submit"],
								.mc4wp-form .mc4wp-form-fields input[type="submit"],
								article .readmore a,
								article .readmore a:hover,
								.quickview .product-info .right .cart button.button,
								.quickview .product-info .right .cart button.button:hover,
								.woocommerce div.product form.cart .button:hover,
								.thim-course-grid .course-item .course-thumbnail > a.course-readmore,
								.thim-course-grid .course-item .course-thumbnail > a.course-readmore:hover,
								.thim-course-list .course-item .thim-course-content .course-readmore a,
								.thim-course-list .course-item .thim-course-content .course-readmore a:hover,
								.learn-press #finish-course,
								.learn-press .thim-enroll-course-button,
								.learn-press #finish-course:hover,
								.learn-press .thim-enroll-course-button:hover,
								.course-content .complete-lesson-button,
								.course-content .complete-lesson-button:hover,
								#tab-course-review .add-review form button[type="submit"],
								#tab-course-review .add-review form button[type="submit"]:hover,
								#tab-course-review .review-load-more #course-review-load-more,
								#tab-course-review .review-load-more #course-review-load-more:hover,
								.become-teacher-form button[type=submit],
								.become-teacher-form button[type=submit]:hover,
								.wrapper-lists-our-team a.join-our-team,
								.wrapper-lists-our-team a.join-our-team:hover,
								.thim-login form#loginform input[type=submit],
								.thim-login form#registerform input[type=submit],
								.thim-login form#lostpasswordform input[type=submit],
								.thim-login form#resetpassform input[type=submit],
								.thim-login form#loginform input[type=submit]:hover,
								.thim-login form#registerform input[type=submit]:hover,
								.thim-login form#lostpasswordform input[type=submit]:hover,
								.thim-login form#resetpassform input[type=submit]:hover,
								.tp-event-archive .entry-content .tp_event_view-detail,
								.tp-event-archive .entry-content .tp_event_view-detail:hover,
								.thim-what-it-about-desc .button .thim-button,
								.thim-join-the-elite-group .thim-widget-button .widget-button.normal,
								.thim-join-the-elite-group .thim-widget-button .widget-button.normal:hover,
								.thim-welcome-university .thim-register-now-form .wpcf7-form .wpcf7-submit,
								.thim-welcome-university .thim-register-now-form .wpcf7-form .wpcf7-submit:hover,
								.thim-course-megamenu .course-readmore,
								.thim-course-megamenu .course-readmore:hover,
								.rev-btn.thim-slider-button,
								.rev-btn.thim-slider-button:hover,
								#learn-press-finish-course,
								form.lp-cart .checkout-button,
								#learn-press-checkout-user-form #learn-press-checkout-user-login ul.form-fields li button,
								#learn-press-checkout-user-form #learn-press-checkout-user-register .form-content a,
								#learn-press-payment .place-order-action input.button,
								.list-book-event thead th a,
								.list-book-event thead td a,
								.list-book-event tbody th a,
								.list-book-event tbody td a,
								.list-book-event thead th a:hover,
								.list-book-event thead td a:hover,
								.list-book-event tbody th a:hover,
								.list-book-event tbody td a:hover,
								#learn-press-form-login input[type="submit"],
								.pmpro-has-access input.pmpro_btn,
								.pmpro-has-access a.pmpro_btn,
								.pmpro-has-access input.pmpro_btn:hover,
								.pmpro-has-access a.pmpro_btn:hover,
								.widget-area.sidebar-events .widget_book-event .event_register_foot .event_register_submit,
								.widget-area.sidebar-events .widget_book-event .event_register_foot .event_register_submit:hover,
								.lp_pmpro_courses_by_level .level-wrap footer a,
								.thim-timetable-link,
								.thim-timetable-link:hover,
								.thim-button-checkout,
								.thim-widget-courses .view-all-courses.position-bottom,
								.woocommerce .add_to_cart_button.ajax_add_to_cart:hover,
								.woocommerce .add_to_cart_button.ajax_add_to_cart,
								.thim-course-landing-button .woocommerce-message a.button,
								.course-payment .woocommerce-message a.button,
								.product-grid .product__title a.button.add_to_cart_button,
								.product-grid .product__title a.button.add_to_cart_button:hover,
								.product-grid .product__title a.button.add_to_cart_button:before,
								.woocommerce div.product .woocommerce-tabs .entry-content #reviews #review_form_wrapper .comment-form .form-submit .submit,
								.woocommerce div.product .woocommerce-tabs .entry-content #reviews #review_form_wrapper .comment-form .form-submit .submit:hover,
								.quickview .product-info .right .cart button.button:hover,
								.widget_shopping_cart .widget_shopping_cart_content .buttons a.checkout:hover,
								.woocommerce div.product form.cart .button:hover,
								.woocommerce-page div.product form.cart .button:hover,
								.woocommerce #payment #place_order:hover,
								.woocommerce-page #payment #place_order:hover,
								.woocommerce .wc-proceed-to-checkout a.button:hover,
								.woocommerce-page .wc-proceed-to-checkout a.button:hover,
								.quickview .product-info .right .cart button.button,
								.widget_shopping_cart .widget_shopping_cart_content .buttons a.checkout,
								.woocommerce div.product form.cart .button,
								.woocommerce-page div.product form.cart .button,
								.woocommerce #payment #place_order,
								.woocommerce-page #payment #place_order,
								.woocommerce .wc-proceed-to-checkout a.button,
								.woocommerce-page .wc-proceed-to-checkout a.button,
								#customer_login form input[type=submit],
								#customer_login form input[type=submit]:hover,
								.woocommerce .reset_password form input[type=submit],
								.woocommerce .reset_password form input[type=submit]:hover,
								.menu-right .thim-link-login a,
								.menu-right .thim-link-login a:hover,
								.woocommerce-MyAccount-content form input.button,
								.woocommerce-MyAccount-content form input.button:hover',
				'property' => 'color',
			),
		),
	)
);

thim_customizer()->add_field(
	array(
		'id'        => 'thim_body_bg_color',
		'type'      => 'color',
		'label'     => esc_html__( 'Body Background Color', 'eduma' ),
		'tooltip'   => esc_html__( 'Allows you to choose background color for body.', 'eduma' ),
		'section'   => 'general_styling',
		'priority'  => 10,
		'choices'   => array( 'alpha' => true ),
		'default'   => '#fff',
		'transport' => 'postMessage',
		'js_vars'   => array(
			array(
				'function' => 'css',
				'element'  => 'body,
								body .content-pusher,
								body #main-content,
								.wpcf7-form.style-01 .contact-form-content .message textarea,
								.wpcf7-form.style-01 .contact-form-content .email input,
								.wpcf7-form.style-01 .contact-form-content .subject input,
								.wpcf7-form.style-01 .contact-form-content .name input,
								.wpcf7-form.style-02 .contact-form-content .name  input,
								.wpcf7-form.style-02 .contact-form-content .email input,
								.wpcf7-form.style-02 .contact-form-content .message textarea,
								.wpcf7-form.style-02 .contact-form-content .subject input',
				'property' => 'background-color',
			),
		),
	)
);

thim_customizer()->add_field(
	array(
		'id'        => 'thim_border_color',
		'type'      => 'color',
		'label'     => esc_html__( 'Border Color', 'eduma' ),
		'section'   => 'general_styling',
		'priority'  => 10,
		'choices'   => array( 'alpha' => true ),
		'default'   => '#eee',
		'transport' => 'postMessage',
	)
);

// Enable or disable title
thim_customizer()->add_field(
	array(
		'id'       => 'thim_content_course_border',
		'type'     => 'switch',
		'label'    => esc_html__( 'Border Radius', 'eduma' ),
		'section'  => 'general_styling',
		'default'  => false,
		'priority' => 13,
		'choices'  => array(
			true  => esc_html__( 'On', 'eduma' ),
			false => esc_html__( 'Off', 'eduma' ),
		),
		'tooltip'  => esc_html__( 'Enable border radius in some places (List Course, Button, Shop, Blog .....)', 'eduma' ),
	)
);
