<?php
/**
 * Created by PhpStorm.
 * User: tagdiv
 * Date: 04.11.2015
 * Time: 10:25
 */

class td_walker_mobile_menu extends Walker_Nav_Menu {

	// The existing menu items are saved here.
	private static $td_menus = array();

	/**
	 * Helper function used internally by the start_el to check if an item of a menu has children.
	 * The requested menu id is cached into $td_menus.
	 *
	 * @param $menu_id - The menu id.
	 * @param $item_id - The item id.
	 *
	 * @return bool
	 */
	private function td_has_children($menu_id, $item_id) {

		// Check if the items of the requested menu are already saved.

		// If they are not, then try to get them.
		if (!array_key_exists($menu_id, self::$td_menus)) {
			$menu_items = wp_get_nav_menu_items($menu_id);

			// Do not set, if they are not available.
			if (isset($menu_items)) {
				self::$td_menus[$menu_id] = $menu_items;
			}
		}

		// Check again and if the key for the requested menu is set, it means that their items are available.
		if (array_key_exists($menu_id, self::$td_menus)) {
			foreach (self::$td_menus[$menu_id] as $menu_item) {
				if (intval($menu_item->menu_item_parent) === $item_id) {
					return true;
				}
			}
		}

		return false;
	}


	public function start_el( &$output, $item, $depth = 0, $args = array(), $id = 0 ) {
		$indent = ( $depth ) ? str_repeat( "\t", $depth ) : '';

		$classes = empty( $item->classes ) ? array() : (array) $item->classes;
		$classes[] = 'menu-item-' . $item->ID;

		/**
		 * Filter the CSS class(es) applied to a menu item's list item element.
		 *
		 * @since 3.0.0
		 * @since 4.1.0 The `$depth` parameter was added.
		 *
		 * @param array  $classes The CSS classes that are applied to the menu item's `<li>` element.
		 * @param object $item    The current menu item.
		 * @param array  $args    An array of {@see wp_nav_menu()} arguments.
		 * @param int    $depth   Depth of menu item. Used for padding.
		 */
		$class_names = join( ' ', apply_filters( 'nav_menu_css_class', array_filter( $classes ), $item, $args, $depth ) );
		$class_names = $class_names ? ' class="' . esc_attr( $class_names ) . '"' : '';

		/**
		 * Filter the ID applied to a menu item's list item element.
		 *
		 * @since 3.0.1
		 * @since 4.1.0 The `$depth` parameter was added.
		 *
		 * @param string $menu_id The ID that is applied to the menu item's `<li>` element.
		 * @param object $item    The current menu item.
		 * @param array  $args    An array of {@see wp_nav_menu()} arguments.
		 * @param int    $depth   Depth of menu item. Used for padding.
		 */
		$id = apply_filters( 'nav_menu_item_id', 'menu-item-'. $item->ID, $item, $args, $depth );
		$id = $id ? ' id="' . esc_attr( $id ) . '"' : '';

		$output .= $indent . '<li' . $id . $class_names .'>';

		$atts = array();
		$atts['title']  = ! empty( $item->attr_title ) ? $item->attr_title : '';
		$atts['target'] = ! empty( $item->target )     ? $item->target     : '';
		$atts['rel']    = ! empty( $item->xfn )        ? $item->xfn        : '';
		$atts['href']   = ! empty( $item->url )        ? $item->url        : '';

		/**
		 * Filter the HTML attributes applied to a menu item's anchor element.
		 *
		 * @since 3.6.0
		 * @since 4.1.0 The `$depth` parameter was added.
		 *
		 * @param array $atts {
		 *     The HTML attributes applied to the menu item's `<a>` element, empty strings are ignored.
		 *
		 *     @type string $title  Title attribute.
		 *     @type string $target Target attribute.
		 *     @type string $rel    The rel attribute.
		 *     @type string $href   The href attribute.
		 * }
		 * @param object $item  The current menu item.
		 * @param array  $args  An array of {@see wp_nav_menu()} arguments.
		 * @param int    $depth Depth of menu item. Used for padding.
		 */
		$atts = apply_filters( 'nav_menu_link_attributes', $atts, $item, $args, $depth );

		$attributes = '';
		foreach ( $atts as $attr => $value ) {
			if ( ! empty( $value ) ) {
				$value = ( 'href' === $attr ) ? esc_url( $value ) : esc_attr( $value );
				$attributes .= ' ' . $attr . '="' . $value . '"';
			}
		}

		$item_output = $args->before;
		$item_output .= '<a'. $attributes .'>';
		/** This filter is documented in wp-includes/post-template.php */
		$item_output .= $args->link_before . apply_filters( 'the_title', $item->title, $item->ID );


		$menu_id = $args->menu;
		if (is_object($args->menu)) {
			$menu_id = $args->menu->term_id;
		}

		// TAGDIV: The $link_after of args is added for parent items
		if (($this->td_has_children($menu_id, $item->ID) === true) ||

		    // Important! This check was introduce because of WPML plugin (the plugin could not render properly the switcher language on mobile)
			(strpos( $item->ID, 'wpml') === 0 && in_array('menu-item-has-children', $item->classes))) {

			$item_output .= $args->link_after;
		}


		$item_output .= '</a>';
		$item_output .= $args->after;

		/**
		 * Filter a menu item's starting output.
		 *
		 * The menu item's starting output only includes `$args->before`, the opening `<a>`,
		 * the menu item's title, the closing `</a>`, and `$args->after`. Currently, there is
		 * no filter for modifying the opening and closing `<li>` for a menu item.
		 *
		 * @since 3.0.0
		 *
		 * @param string $item_output The menu item's starting HTML output.
		 * @param object $item        Menu item data object.
		 * @param int    $depth       Depth of menu item. Used for padding.
		 * @param array  $args        An array of {@see wp_nav_menu()} arguments.
		 */
		$output .= apply_filters( 'walker_nav_menu_start_el', $item_output, $item, $depth, $args );
	}
}